<?php 
session_start();
include('connection.php');

if(isset($_SESSION['admin_login'])){
    $admin_username = $_SESSION['admin_login'];

    // Search functionality
    $search_query = '';
    if (isset($_POST['search'])) {
        $search_term = mysqli_real_escape_string($con, $_POST['search']);
        // Update the search query to include posted_by as well
        $search_query = "WHERE title LIKE '%$search_term%' OR message LIKE '%$search_term%' OR target_type LIKE '%$search_term%' OR posted_by LIKE '%$search_term%'";
    }

    // Pagination logic
    $limit = 10; // Number of records per page
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $start = ($page - 1) * $limit;

    $query = "SELECT * FROM announcements $search_query ORDER BY announcement_date DESC LIMIT $start, $limit";
    $result = mysqli_query($con, $query);

    // Get total number of announcements for pagination
    $total_result_query = "SELECT COUNT(*) AS total FROM announcements $search_query";
    $total_result = mysqli_query($con, $total_result_query);
    $total_row = mysqli_fetch_assoc($total_result);
    $total_announcements = $total_row['total'];
    $total_pages = ceil($total_announcements / $limit);

    if (mysqli_num_rows($result) > 0) {
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Admin - Manage Announcements</title>
            <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
            <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
        </head>
        <body>
            <div class="container mt-5">
                <h2>Manage Announcements</h2>

                <!-- Button to Create New Announcement -->
                <a href="admin_create_parentsannouncements.php" class="btn btn-success mb-3">Create New Announcement</a>

                <!-- Display Total Number of Announcements -->
                <div class="alert alert-info" role="alert">
                    <strong>Total Announcements:</strong> <?php echo $total_announcements; ?>
                </div>

                <!-- Search Form -->
                <form method="POST" class="mb-3">
                    <div class="input-group">
                        <input type="text" class="form-control" name="search" placeholder="Search announcements..." value="<?php echo isset($search_term) ? $search_term : ''; ?>">
                        <div class="input-group-append">
                            <button class="btn btn-primary" type="submit">Search</button>
                        </div>
                    </div>
                </form>

                <!-- Announcements Table -->
                <table class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Title</th>
                            <th>Message</th>
                            <th>Posted By</th>
                            <th>Posted To</th>
                            <th>Target Type</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $counter = $start + 1; // To display the correct number on the pagination
                        while ($row = mysqli_fetch_assoc($result)) { ?>
                            <tr>
                                <td><?php echo $counter++; ?></td>
                                <td><?php echo htmlspecialchars($row['title']); ?></td>
                                <td><?php echo htmlspecialchars($row['message']); ?></td>
                                <td><?php echo htmlspecialchars($row['posted_by']); ?></td>
                                <td><?php echo htmlspecialchars($row['posted_to']); ?></td>
                                <td><?php echo htmlspecialchars($row['target_type']); ?></td>
                                <td>
                                    <a href="edit_parentannouncement.php?id=<?php echo $row['id']; ?>" class="btn btn-warning btn-sm">Edit</a>
                                    <a href="delete_parentannouncement.php?id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this announcement?')">Delete</a>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>

                <!-- Pagination -->
                <nav>
                    <ul class="pagination justify-content-center">
                        <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                            <a class="page-link" href="?page=1">First</a>
                        </li>
                        <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $page - 1; ?>">Previous</a>
                        </li>
                        <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $page + 1; ?>">Next</a>
                        </li>
                        <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $total_pages; ?>">Last</a>
                        </li>
                    </ul>
                </nav>
            </div>
        </body>
        </html>
        <?php
    } else {
        echo "<p>No announcements found.</p>";
    }
}
?>
